/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class PerformanceTimer {
    private static PerformanceTimer _instance = null;
    private static final Logger LOG = Logger.getLogger(PerformanceTimer.class);
    private HashMap _startTimes = new HashMap();

    private PerformanceTimer() {
    }

    public static PerformanceTimer getInstance() {
        if (_instance == null) {
            _instance = new PerformanceTimer();
        }
        return _instance;
    }

    public static void start() {
        PerformanceTimer.getInstance().start(Thread.currentThread());
    }

    public static void stop() {
        PerformanceTimer.getInstance().stop(Thread.currentThread());
    }

    public void start(Thread owner) {
        if (LOG.isDebugEnabled()) {
            StartTime time = (StartTime)this._startTimes.get(owner);
            if (time == null) {
                time = new StartTime();
                this._startTimes.put(owner, time);
            }
            time.setTime(System.currentTimeMillis());
        }
    }

    public void stop(Thread owner) {
        if (LOG.isDebugEnabled()) {
            long stop = System.currentTimeMillis();
            StartTime start = (StartTime)this._startTimes.get(owner);
            if (start == null) {
                LOG.debug((Object)("The '" + owner.getName() + " thread never started a time."));
            } else {
                long time = stop - start.getTime();
                ThrowableTraceTextParser t = new ThrowableTraceTextParser(new Exception());
                LOG.debug((Object)(t.getLastCall() + " on thread '" + owner.getName() + "' took " + time + " milliseconds."));
            }
        }
    }

    private static final class StartTime {
        private long _time = 0L;

        private StartTime() {
        }

        public void setTime(long time) {
            this._time = time;
        }

        public long getTime() {
            return this._time;
        }
    }

    private static final class ThrowableTraceTextParser {
        private String _lastCall = null;

        private ThrowableTraceTextParser(Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            int start = trace.lastIndexOf("PerformanceTimer.java");
            start = trace.indexOf("at ", start) + "at ".length();
            int end = trace.indexOf(41, start) + 1;
            this._lastCall = trace.substring(start, end);
        }

        private String getLastCall() {
            return this._lastCall;
        }
    }
}

