/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class NestedException
extends Exception {
    private static final String SEPARATOR = ": ";
    private static final String NESTED_EXCEPTION = "Nested Exception: ";
    private Throwable _cause = null;
    private String _message = null;

    public NestedException() {
    }

    public NestedException(String message) {
        this(message, null);
    }

    public NestedException(Throwable cause) {
        this(null, cause);
    }

    public NestedException(String message, Throwable cause) {
        this._message = message;
        this._cause = cause;
    }

    protected void setCause(Throwable cause) {
        this._cause = cause;
    }

    protected void setMessage(String message) {
        this._message = message;
    }

    @Override
    public void printStackTrace() {
        if (this._message != null) {
            System.err.println(this.getClass().getName() + SEPARATOR + this._message);
        }
        super.printStackTrace();
        if (this._cause != null) {
            System.err.print(NESTED_EXCEPTION);
            this._cause.printStackTrace();
        }
    }

    public void printStrackTrace(PrintStream s) {
        if (this._message != null) {
            s.println(this.getClass().getName() + SEPARATOR + this._message);
        }
        super.printStackTrace(s);
        if (this._cause != null) {
            s.print(NESTED_EXCEPTION);
            this._cause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        if (this._message != null) {
            w.println(this.getClass().getName() + SEPARATOR + this._message);
        }
        super.printStackTrace(w);
        if (this._cause != null) {
            w.print(NESTED_EXCEPTION);
            this._cause.printStackTrace(w);
        }
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    @Override
    public String toString() {
        if (this._message != null) {
            return this.getClass().getName() + SEPARATOR + this._message;
        }
        return this.getClass().getName();
    }
}

