/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import gov.grants.commons.s2s.util.JaxwsUtil;
import gov.grants.commons.test.BaseTest;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JaxwsUtilTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)JaxwsUtilTest.class.getName());

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void updateCid() {
        try {
            String cid = null;
            String cleanedCid = null;
            cid = "<cid:localhost@1234.org.filename.2>";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"valid cid with < >", (Object)"cid:localhost@1234.org.filename.2", (Object)cleanedCid);
            cid = "cid:localhost@1234.org.filename.2";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"valid cid without < >", (Object)cid, (Object)cleanedCid);
            cid = "";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid empty string", (Object)cid, (Object)cleanedCid);
            cid = "  ";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid spaces", (Object)cid, (Object)cleanedCid);
            cid = null;
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid null", (Object)cid, (Object)cleanedCid);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
    }

    @Test
    public void cleanCid() {
        try {
            String cid = null;
            String cleanedCid = null;
            cid = "<cid:localhost@1234.org.filename.2>";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"valid cid with < >", (Object)"cid:localhost@1234.org.filename.2", (Object)cleanedCid);
            cid = "cid:localhost@1234.org.filename.2";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"valid cid without < >", (Object)cid, (Object)cleanedCid);
            cid = "";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid empty string", (Object)cid, (Object)cleanedCid);
            cid = "  ";
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid spaces", (Object)cid, (Object)cleanedCid);
            cid = null;
            cleanedCid = JaxwsUtil.cleanCid(cid);
            Assert.assertEquals((String)"cid null", (Object)cid, (Object)cleanedCid);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
    }
}

