/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.util.HashSet;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.log4j.Logger;

public class JaxwsUtil {
    private static final Logger log = Logger.getLogger((String)JaxwsUtil.class.getName());

    public static boolean updateAttMapKeys(Map<String, DataHandler> m) {
        try {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(m.keySet());
            int count = 0;
            String cid = null;
            DataHandler dh = null;
            for (String key : keys) {
                dh = m.remove(key);
                cid = JaxwsUtil.cleanCid(key);
                m.put(cid, dh);
                ++count;
            }
            log.debug((Object)("total map items checked: " + count));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught updating attachment map keys: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static String cleanCid(String cid) {
        if (cid == null) {
            log.info((Object)("cid is null, return cid: " + cid));
            return cid;
        }
        if (cid.startsWith("<")) {
            cid = cid.substring(1);
        }
        if (cid.endsWith(">")) {
            cid = cid.substring(0, cid.length() - 1);
        }
        return cid;
    }
}

