/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.text.MessageFormat;

public class InvalidHashValueException
extends Exception {
    private static final String MESSAGE_TEMPLATE = "The hash value calculated from the Grant application XML does not match the hash value in its header.  The expected value is \"{0}\" but the header has \"{1}\".";

    public InvalidHashValueException(String calculatedHash, String hashFromHeader) {
        super(MessageFormat.format(MESSAGE_TEMPLATE, InvalidHashValueException._makeArray(calculatedHash, hashFromHeader)));
    }

    private static final String[] _makeArray(String calculatedHash, String hashFromHeader) {
        String[] args = new String[]{calculatedHash, hashFromHeader};
        return args;
    }

    public static final void main(String[] args) {
        InvalidHashValueException e = new InvalidHashValueException("calculated", "in header");
        e.printStackTrace();
    }
}

