/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import gov.grants.commons.s2s.util.GrantApplicationHash;
import gov.grants.commons.s2s.xpath.GrantApplicationXpath;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.Timer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GrantApplicationHashTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)GrantApplicationHashTest.class.getName());
    private static final String SP_XML_HASH_VALUE = "uHL9N7oaf1L4+zQmcU+QYSnMLdU=";
    private static Map<String, String> ATTACHMENT_HASH_MAP;
    private String attachmentHashValueFromMap;
    private byte[] attachmentBytes;
    private String xmlStr;
    private Document document;
    private Timer timer;
    private GrantApplicationXpath grantAppXpath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
        this.artifactSubDir = "grantApplicationHashTest/";
        this.initAttachmentHashMap();
        InputStream inStream = null;
        String xmlFileName = "SingleProject.xml";
        String xmlFilePath = this.artifactSubDir + xmlFileName;
        try {
            byte[] xmlBytes = null;
            log.debug((Object)"Load SingleProject.xml");
            inStream = BaseTest.class.getResourceAsStream(xmlFilePath);
            xmlBytes = FileUtil.getBytes(inStream);
            log.debug((Object)("single project xmlBytes size: " + xmlBytes.length));
            this.xmlStr = new String(xmlBytes);
            log.debug((Object)"create GrantApplicationXpath instance");
            this.grantAppXpath = new GrantApplicationXpath(this.xmlStr);
        }
        catch (Exception e) {
            log.error((Object)("Exception loading xml: " + e.getMessage()));
            Assert.fail((String)("Exception loading xml: " + e.getMessage()));
        }
        try {
            inStream = BaseTest.class.getResourceAsStream(xmlFilePath);
            log.debug((Object)"create DocumentBuilderFactory instance");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            log.debug((Object)"parse xml input stream");
            this.document = factory.newDocumentBuilder().parse(inStream);
            log.debug((Object)"xml successfully parsed");
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml stream: " + e.getMessage()));
            Assert.fail((String)("Exception parsing xml stream: " + e.getMessage()));
        }
        finally {
            try {
                log.debug((Object)"close input stream");
                inStream.close();
            }
            catch (Exception e) {}
        }
        String attName = null;
        String attPath = null;
        try {
            attName = "attachment_excel.xlsx";
            attPath = this.artifactSubDir + attName;
            log.debug((Object)("load attachment bytes: " + attPath));
            this.attachmentHashValueFromMap = ATTACHMENT_HASH_MAP.get(attName);
            log.debug((Object)("attachmentHashValueFromMap: " + this.attachmentHashValueFromMap));
            inStream = BaseTest.class.getResourceAsStream(attPath);
            this.attachmentBytes = FileUtil.getBytes(inStream);
            log.debug((Object)("attachmentBytes length: " + this.attachmentBytes.length));
        }
        catch (Exception e) {
            log.error((Object)("Exception loading attachment (" + attPath + "): " + e.getMessage()));
            Assert.fail((String)("Exception loading attachment (" + attPath + "): " + e.getMessage()));
        }
        finally {
            try {
                log.debug((Object)"close input stream");
                inStream.close();
            }
            catch (Exception exception) {}
        }
    }

    @After
    public void tearDown() {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public final void hashXmlTest() {
        try {
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            log.debug((Object)gAppHash.computeGrantFormsHash(this.xmlStr));
            Assert.assertEquals((String)"Hash values did not match.", (Object)SP_XML_HASH_VALUE, (Object)gAppHash.computeGrantFormsHash(this.xmlStr));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void hashDocumentTest() {
        try {
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            String hashValue = gAppHash.computeGrantFormsHash(this.document);
            log.debug((Object)("calculated forms hash from document: " + hashValue));
            Assert.assertEquals((String)"Hash values did not match.", (Object)SP_XML_HASH_VALUE, (Object)hashValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void hashXpathTest() {
        try {
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            String hashValue = gAppHash.computeGrantFormsHash(this.grantAppXpath);
            log.debug((Object)("calculated form hash value from grantAppXpath: " + hashValue));
            Assert.assertEquals((String)"Hash values did not match.", (Object)SP_XML_HASH_VALUE, (Object)hashValue);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void hashAttachmentTest() {
        try {
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            String hashValue = gAppHash.computeAttachmentHash(this.attachmentBytes);
            log.debug((Object)("calculated attachment hash value: " + hashValue));
            Assert.assertEquals((String)"Hash values did not match.", (Object)this.attachmentHashValueFromMap, (Object)hashValue);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void initAttachmentHashMap() {
        log.debug((Object)"Initializing ATTACHMENT_HASH_MAP");
        ATTACHMENT_HASH_MAP = new HashMap<String, String>();
        ATTACHMENT_HASH_MAP.put("attachment_text.txt", "8w0Q/DFrkWBi3OUeEo0udsyKMD8=");
        ATTACHMENT_HASH_MAP.put("attachment_word.docx", "6ni8+loGTPfOsvLxcrankX4EG4s=");
        ATTACHMENT_HASH_MAP.put("attachment_excel.xlsx", "RtblHxZdTtDPWNHQyNjMMMAE3iE=");
        log.debug((Object)("Initialized ATTACHMENT_HASH_MAP: " + ATTACHMENT_HASH_MAP));
    }
}

