/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import gov.grants.commons.s2s.util.PropertiesLoader;
import gov.grants.commons.s2s.util.ToFileFirstOutputStream;
import gov.grants.commons.s2s.xpath.GrantApplicationXpath;
import gov.grants.commons.s2s.xpath.XPathExecutor;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GrantApplicationHash {
    static final Logger log = Logger.getLogger((String)GrantApplicationHash.class.getName());
    MessageDigest messageDigester = null;

    public GrantApplicationHash() {
        try {
            this.messageDigester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"Unable to get instance of java.security.MessageDigester", (Throwable)e);
        }
    }

    public String computeGrantFormsHash(String xml) throws Exception {
        GrantApplicationXpath xpath = new GrantApplicationXpath(xml);
        return this._hash(xpath);
    }

    public String computeAttachmentHash(byte[] attachment) throws Exception {
        byte[] rawDigest = this.messageDigester.digest(attachment);
        return Base64.encode((byte[])rawDigest);
    }

    public String computeAttachmentHash(InputStream attStream) throws Exception {
        try (FilterInputStream dis = null;){
            dis = new DigestInputStream(attStream, this.messageDigester);
            ((DigestInputStream)dis).on(true);
            int bufferSize = 65536;
            byte[] buffer = new byte[bufferSize];
            while (dis.read(buffer) != -1) {
            }
            byte[] rawDigest = this.messageDigester.digest();
            String string = Base64.encode((byte[])rawDigest);
            return string;
        }
    }

    public String computeGrantFormsHash(GrantApplicationXpath xpath) throws Exception {
        return this._hash(xpath);
    }

    public final String computeGrantFormsHash(Document xml) throws Exception {
        XPathExecutor executor = new XPathExecutor(null);
        executor.setDoc(xml);
        GrantApplicationXpath xpath = new GrantApplicationXpath();
        xpath.setExecutor(executor);
        return this._hash(xpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _hash(GrantApplicationXpath xpath) throws TransformerException, XMLSignatureException, InvalidCanonicalizerException, CanonicalizationException {
        DigesterOutputStream digester;
        Node formsNode = xpath.getFormsNode();
        Object stream = digester = this._createDigesterOutputStream(xpath.getExecutor().getDoc());
        byte[] hash = null;
        String debugFileName = PropertiesLoader.getValue("debug.properties", "gov.grants.c14n.debug.filename");
        if (debugFileName != null) {
            log.debug((Object)("Writing canonicalized XML to " + debugFileName));
            try {
                stream = new ToFileFirstOutputStream(debugFileName, (OutputStream)digester);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)"Unable to create canonicalizer debug file.");
            }
        }
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
        canonicalizer.setWriter((OutputStream)stream);
        try {
            canonicalizer.canonicalizeSubtree(formsNode);
            hash = digester.getDigestValue();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Exception while closing out stream for digester.", (Throwable)e);
            }
        }
        return Base64.encode((byte[])hash);
    }

    private DigesterOutputStream _createDigesterOutputStream(Document doc) throws XMLSignatureException {
        DigesterOutputStream dos = null;
        if (doc != null) {
            dos = new DigesterOutputStream(MessageDigestAlgorithm.getInstance((Document)doc, (String)"http://www.w3.org/2000/09/xmldsig#sha1"));
        }
        return dos;
    }

    static {
        Init.init();
    }
}

