/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static final Logger LOG = Logger.getLogger(DOMUtils.class);

    public static final Document createDocument(String xml, boolean namespaceAware, boolean validating) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return DOMUtils.createDocument(stream, namespaceAware, validating);
    }

    public static final Document createDocument(InputStream stream, boolean namespaceAware, boolean validating) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(stream);
    }

    public static final String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer();
        serializer.setOutputByteStream((OutputStream)stream);
        OutputFormat format = new OutputFormat(doc);
        format.setPreserveSpace(true);
        serializer.setOutputFormat(format);
        serializer.serialize(doc);
        return stream.toString();
    }
}

