/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.activation.DataSource;
import org.apache.log4j.Logger;

public final class ByteArrayDataSource
implements DataSource {
    private static final Logger LOG = Logger.getLogger(ByteArrayDataSource.class);
    private String _contentType = null;
    private String _name = null;
    private byte[] _data = null;
    private ArrayList _inputStreams = null;

    public ByteArrayDataSource(String contentType, String name, byte[] data) {
        this._contentType = contentType;
        this._name = name;
        this._data = data;
    }

    public String getContentType() {
        return this._contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this._data == null) {
            LOG.warn((Object)"Was asked to getInputStream from a null byte array.");
            return null;
        }
        ByteArrayDSInputStream stream = new ByteArrayDSInputStream(new ByteArrayInputStream(this._data), this);
        if (this._inputStreams == null) {
            this._inputStreams = new ArrayList();
        }
        this._inputStreams.add(stream);
        return stream;
    }

    public String getName() {
        return this._name;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._data == null) {
            LOG.warn((Object)"Asked for an outputStream when byte array is null.");
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(this._data.length + 100);
        stream.write(this._data, 0, this._data.length);
        return new ByteArrayDSOutputStream(stream, this);
    }

    private synchronized void removeStream(ByteArrayDSInputStream stream) {
        int size = this._inputStreams != null ? this._inputStreams.size() : 0;
        for (int i = 0; this._inputStreams != null && i < size; ++i) {
            if (this._inputStreams.get(i) != stream) continue;
            this._inputStreams.remove(i);
            break;
        }
    }

    private synchronized void alertModified() {
        Iterator iter = this._inputStreams.iterator();
        while (iter.hasNext()) {
            ((ByteArrayDSInputStream)iter.next()).alertModified();
        }
    }

    private synchronized void setData(byte[] data) {
        this._data = data;
    }

    public byte[] getData() {
        return this._data;
    }

    private static final class ByteArrayDSOutputStream
    extends OutputStream {
        ByteArrayOutputStream _stream = null;
        ByteArrayDataSource _owner = null;

        public ByteArrayDSOutputStream(ByteArrayOutputStream stream, ByteArrayDataSource owner) {
            this._stream = stream;
            this._owner = owner;
        }

        @Override
        public void flush() throws IOException {
            this._stream.flush();
            this._owner.setData(this._stream.toByteArray());
        }

        @Override
        public void close() throws IOException {
            this._stream.close();
            this._owner.setData(this._stream.toByteArray());
        }

        @Override
        public void write(byte[] b) throws IOException {
            this._owner.alertModified();
            this._stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this._stream.write(b, off, len);
        }

        @Override
        public void write(int b) {
            this._stream.write(b);
        }
    }

    private static final class ByteArrayDSInputStream
    extends InputStream {
        private ByteArrayInputStream _stream = null;
        private ByteArrayDataSource _owner = null;
        private boolean _isModified = false;

        private ByteArrayDSInputStream(ByteArrayInputStream stream, ByteArrayDataSource owner) {
            this._stream = stream;
            this._owner = owner;
        }

        @Override
        public int available() {
            return this._stream.available();
        }

        @Override
        public void close() throws IOException {
            this._stream.close();
            this._owner.removeStream(this);
        }

        @Override
        public void mark(int readAheadLimit) {
            this._stream.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this._stream.markSupported();
        }

        private void alertModified() {
            this._isModified = true;
        }

        @Override
        public int read() {
            if (this._isModified) {
                throw new ConcurrentModificationException("The byte array in this data source has been written to at the same time as it is being read.");
            }
            return this._stream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this._isModified) {
                throw new ConcurrentModificationException("The byte array in this data source has been written to at the same time as it is being read.");
            }
            return this._stream.read(b, off, len);
        }

        @Override
        public void reset() {
            this._stream.reset();
        }

        @Override
        public long skip(long n) {
            return this._stream.skip(n);
        }
    }
}

