/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.jmx;

import gov.grants.commons.jmx.Log4jAdminMBean;
import gov.grants.commons.jmx.LoggerLevelEnum;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jAdmin
implements Log4jAdminMBean {
    private HashMap<String, Logger> loggerClasses = new HashMap(200);

    @Override
    public String getAllLoggers(String packageName) {
        StringBuilder sb = new StringBuilder();
        this.loggerClasses.clear();
        Enumeration loggers = LogManager.getCurrentLoggers();
        Logger rootLogger = LogManager.getRootLogger();
        this.loggerClasses.put(rootLogger.getName(), rootLogger);
        sb.append(String.format("%1$-50s = ", rootLogger.getName()));
        sb.append(rootLogger.getEffectiveLevel().toString()).append("\n");
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().startsWith(packageName)) continue;
            this.loggerClasses.put(logger.getName(), logger);
            sb.append(String.format("%1$-50s = ", logger.getName()));
            sb.append(logger.getEffectiveLevel().toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getLoggerClassLevel(String loggerClassName) {
        return this.loggerClasses.containsKey(loggerClassName) ? String.valueOf(this.loggerClasses.get(loggerClassName).getEffectiveLevel()) : null;
    }

    @Override
    public boolean changeLoggerClassLogLevel(String loggerClassName, String level) {
        if (LoggerLevelEnum.valueOf(level) != null && this.loggerClasses.containsKey(loggerClassName)) {
            Logger logger = this.loggerClasses.get(loggerClassName);
            logger.setLevel(Level.toLevel((String)level));
            return true;
        }
        return false;
    }
}

