/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.db.orm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class StringClobType
implements UserType {
    private static final String ORACLE_DRIVER_NAME = "Oracle JDBC driver";
    private static final int ORACLE_DRIVER_MAJOR_VERSION = 9;
    private static final int ORACLE_DRIVER_MINOR_VERSION = 0;

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Reader clobReader = rs.getCharacterStream(names[0]);
        if (clobReader == null) {
            return null;
        }
        String str = new String();
        BufferedReader bufferedClobReader = new BufferedReader(clobReader);
        try {
            String line = null;
            while ((line = bufferedClobReader.readLine()) != null) {
                str = str + line;
            }
            bufferedClobReader.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        DatabaseMetaData dbMetaData = st.getConnection().getMetaData();
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
            return;
        } else if (ORACLE_DRIVER_NAME.equals(dbMetaData.getDriverName())) {
            if (dbMetaData.getDriverMajorVersion() < 9 || dbMetaData.getDriverMinorVersion() < 0) throw new HibernateException("No CLOBS support. Use driver version 9, minor 0");
            try {
                Class<?> oracleClobClass = Class.forName("oracle.sql.CLOB");
                Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
                Class[] partypes = new Class[]{Connection.class, Boolean.TYPE, Integer.TYPE};
                Method createTemporaryMethod = oracleClobClass.getDeclaredMethod("createTemporary", partypes);
                Field durationSessionField = oracleClobClass.getField("DURATION_SESSION");
                Object[] arglist = new Object[3];
                Connection conn = st.getConnection().getMetaData().getConnection();
                if (!oracleConnectionClass.isAssignableFrom(conn.getClass())) {
                    throw new HibernateException("JDBC connection object must be an oracle.jdbc.OracleConnection. Connection class is " + conn.getClass().getName());
                }
                arglist[0] = conn;
                arglist[1] = Boolean.TRUE;
                arglist[2] = durationSessionField.get(null);
                Object tempClob = createTemporaryMethod.invoke(null, arglist);
                partypes = new Class[]{Integer.TYPE};
                Method openMethod = oracleClobClass.getDeclaredMethod("open", partypes);
                Field modeReadWriteField = oracleClobClass.getField("MODE_READWRITE");
                arglist = new Object[]{modeReadWriteField.get(null)};
                openMethod.invoke(tempClob, arglist);
                Method getCharacterOutputStreamMethod = oracleClobClass.getDeclaredMethod("getCharacterOutputStream", null);
                Writer tempClobWriter = (Writer)getCharacterOutputStreamMethod.invoke(tempClob, null);
                tempClobWriter.write((String)value);
                tempClobWriter.flush();
                tempClobWriter.close();
                Method closeMethod = oracleClobClass.getDeclaredMethod("close", null);
                closeMethod.invoke(tempClob, null);
                st.setClob(index, (Clob)tempClob);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Unable to find a required class.\n" + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Unable to find a required method.\n" + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new HibernateException("Unable to find a required field.\n" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access a required method or field.\n" + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new HibernateException(e.getMessage());
            }
            catch (IOException e) {
                throw new HibernateException(e.getMessage());
            }
        } else {
            String str = (String)value;
            StringReader r = new StringReader(str);
            st.setCharacterStream(index, (Reader)r, str.length());
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        return new String((String)value);
    }

    public boolean isMutable() {
        return false;
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return null;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return null;
    }

    public int hashCode(Object arg0) throws HibernateException {
        return 0;
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return null;
    }
}

