/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.db.orm;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.sql.BLOB;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class BinaryBlobType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
            return;
        }
        try {
            Connection conn = st.getConnection().getMetaData().getConnection();
            OutputStream tempBlobOutputStream = null;
            BLOB tempBlob = BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
            try {
                tempBlob.open(1);
                tempBlobOutputStream = tempBlob.getBinaryOutputStream();
                tempBlobOutputStream.write((byte[])value);
                tempBlobOutputStream.flush();
            }
            finally {
                if (tempBlobOutputStream != null) {
                    tempBlobOutputStream.close();
                }
                tempBlobOutputStream.close();
            }
            st.setBlob(index, (Blob)tempBlob);
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = rs.getBlob(names[0]);
        return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return null;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return null;
    }

    public int hashCode(Object arg0) throws HibernateException {
        return 0;
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return null;
    }
}

