/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.dao;

import gov.grants.commons.dao.HibernateEscapedLikeExpression;
import gov.grants.commons.dao.SearchClause;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;

public class LikeClauseWithEscape
implements SearchClause {
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    public static final String[][] WILDCARD_MAP = new String[][]{{"*", "%"}, {"?", "_"}};
    private String propertyName;
    private String value;
    private boolean ignoreCase = false;
    private MatchMode matchMode;

    public LikeClauseWithEscape(String propertyName, String value, MatchMode matchMode) {
        this.propertyName = propertyName;
        this.value = value;
        this.matchMode = matchMode;
    }

    public LikeClauseWithEscape(String propertyName, String value, MatchMode matchMode, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.value = value;
        this.matchMode = matchMode;
        this.ignoreCase = ignoreCase;
    }

    public LikeClauseWithEscape(String propertyName, String value, MatchMode matchMode, boolean ignoreCase, String[] escapeChars) {
        this.propertyName = propertyName;
        this.value = LikeClauseWithEscape.escape(value, escapeChars);
        this.matchMode = matchMode;
        this.ignoreCase = ignoreCase;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Criterion getHibernateClause() {
        if (this.matchMode == null) {
            this.matchMode = MatchMode.EXACT;
        }
        return new HibernateEscapedLikeExpression(this.propertyName, this.value, this.matchMode, Character.valueOf('\\'), this.ignoreCase);
    }

    public static String escape(String value, String[] charsToEscape) {
        for (String c : charsToEscape) {
            value = value.replace(c, '\\' + c);
        }
        return value;
    }

    public static String escapeSqlWildcards(String value) {
        for (String[] pair : WILDCARD_MAP) {
            value = value.replace(pair[1], '\\' + pair[1]);
        }
        return value;
    }

    public static String replaceWithSqlWildcard(String value) {
        for (String[] pair : WILDCARD_MAP) {
            value = value.replace(pair[0], pair[1]);
        }
        return value;
    }
}

