/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.dao;

import gov.grants.commons.dao.CriteriaAlias;
import gov.grants.commons.dao.HibernateGenericsDAO;
import gov.grants.commons.dao.SearchClause;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class HibernateGenericsTransactionalDAO<T, ID extends Serializable>
extends HibernateGenericsDAO<T, ID> {
    public HibernateGenericsTransactionalDAO(Class<T> genericsClass) {
        super(genericsClass, "hibernateSessionFactory");
    }

    public HibernateGenericsTransactionalDAO(Class<T> genericsClass, String sessionFactoryName) {
        super(genericsClass, sessionFactoryName);
    }

    public HibernateGenericsTransactionalDAO(Class<T> genericsClass, SessionFactory sessionFactory) {
        super(genericsClass, sessionFactory);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    @Override
    public void update(T entity) throws HibernateException {
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            session.update(entity);
            session.flush();
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(T entity) throws HibernateException {
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            session.save(entity);
            session.flush();
            transaction.commit();
        }
    }

    @Override
    public void saveOrUpdate(T entity) throws HibernateException {
        log.debug((Object)("--- save/update: " + entity));
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            session.saveOrUpdate(entity);
            session.flush();
            transaction.commit();
        }
    }

    @Override
    public void saveOrUpdateAll(Collection<T> entities) throws HibernateException {
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            for (T entity : entities) {
                session.saveOrUpdate(entity);
            }
            session.flush();
            transaction.commit();
        }
    }

    @Override
    public void delete(T entity) throws HibernateException {
        this.getHibernateTemplate().delete(entity);
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            session.delete(entity);
            session.flush();
            transaction.commit();
        }
    }

    @Override
    public void deleteAll(Collection<T> entities) throws HibernateException {
        Transaction transaction = null;
        try (Session session = this.getSession();){
            transaction = session.beginTransaction();
            for (T entity : entities) {
                session.delete(entity);
            }
            session.flush();
            transaction.commit();
        }
    }

    public void deleteByCriteria(List<SearchClause> searchClauses) throws HibernateException {
        this.deleteByCriteria(searchClauses, null);
    }

    public void deleteByCriteria(List<SearchClause> searchClauses, List<CriteriaAlias> aliases) throws HibernateException {
        List entities = this.findByCriteria(searchClauses, null, aliases);
        this.deleteAll(entities);
    }
}

