/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.dao;

import gov.grants.commons.dao.CriteriaAlias;
import gov.grants.commons.dao.OrderByClause;
import gov.grants.commons.dao.QueryParam;
import gov.grants.commons.dao.SearchClause;
import gov.grants.commons.util.SpringServiceLocator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateGenericsDAO<T, ID extends Serializable>
extends HibernateDaoSupport {
    protected static final transient Logger log = Logger.getLogger((String)HibernateGenericsDAO.class.getName());
    protected static final String NULL = "NULL";
    private Class<T> persistentClass;
    private SessionFactory sessionFactoryLocal;

    public HibernateGenericsDAO(Class<T> genericsClass) {
        this(genericsClass, "hibernateSessionFactory");
    }

    public HibernateGenericsDAO(Class<T> genericsClass, String sessionFactoryName) {
        this.persistentClass = genericsClass;
        log.info((Object)"Loading (spring) session factory");
        this.sessionFactoryLocal = (SessionFactory)SpringServiceLocator.get(sessionFactoryName);
        this.setSessionFactory(this.sessionFactoryLocal);
    }

    public HibernateGenericsDAO(Class<T> genericsClass, SessionFactory sessionFactory) {
        this.persistentClass = genericsClass;
        this.sessionFactoryLocal = sessionFactory;
        this.setSessionFactory(this.sessionFactoryLocal);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    public void closeSession() {
        log.debug((Object)("closing session: " + this.getSession()));
        this.closeSession(this.getSession());
    }

    public Session getHibernateSession() {
        return this.getSession();
    }

    private void closeSession(Session s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (HibernateException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public List<T> loadAll() {
        return this.getHibernateTemplate().loadAll(this.persistentClass);
    }

    public List<T> find(String hql) {
        return this.getHibernateTemplate().find(hql);
    }

    public void update(T entity) {
        this.getHibernateTemplate().update(entity);
    }

    public void save(T entity) {
        this.getHibernateTemplate().save(entity);
    }

    public void saveOrUpdate(T entity) {
        log.debug((Object)("sessionFactoryLocal: " + this.sessionFactoryLocal));
        log.debug((Object)("--- save/update: " + entity));
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public void saveOrUpdateAll(Collection<T> entities) {
        this.getHibernateTemplate().saveOrUpdateAll(entities);
    }

    public void delete(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteAll(Collection<T> entities) {
        this.getHibernateTemplate().deleteAll(entities);
    }

    public List<T> findByExample(T exampleEntity) {
        List result = this.getHibernateTemplate().findByExample(exampleEntity);
        log.debug((Object)("result count: " + result.size()));
        return result;
    }

    public T findById(ID id) {
        log.debug((Object)("find by id: " + id));
        Object obj = this.getHibernateTemplate().get(this.persistentClass, id);
        return (T)obj;
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public List<T> findByCriteria(DetachedCriteria criteria) throws DataAccessException {
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    public List<T> findByCriteria(List<SearchClause> searchClauses, boolean reportException) throws Exception {
        return this.findByCriteria(searchClauses, null, null, false, reportException);
    }

    public List<T> findByCriteria(List<SearchClause> searchClauses) {
        return this.findByCriteria(searchClauses, null);
    }

    public List<T> findByCriteria(List<SearchClause> searchClauses, List<OrderByClause> orderByClauses) {
        return this.findByCriteria(searchClauses, orderByClauses, null);
    }

    public List<T> findByCriteria(List<SearchClause> searchClauses, List<OrderByClause> orderByClauses, List<CriteriaAlias> aliases) {
        return this.findByCriteria(searchClauses, orderByClauses, aliases, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findByCriteria(List<SearchClause> searchClauses, List<OrderByClause> orderByClauses, List<CriteriaAlias> aliases, boolean distinct, boolean reportException) throws Exception {
        Session session = null;
        List result = new ArrayList();
        try {
            log.debug((Object)(">>> searchClauses: " + searchClauses));
            log.debug((Object)(">>> orderByClauses: " + orderByClauses));
            session = this.getSession();
            log.debug((Object)("Hibernate session: " + session));
            log.debug((Object)("Create criteria with class: " + this.persistentClass));
            Criteria criteria = session.createCriteria(this.persistentClass);
            log.debug((Object)("Criteria instance: " + criteria));
            if (aliases != null && aliases.size() > 0) {
                for (CriteriaAlias alias : aliases) {
                    alias.createAlias(criteria);
                }
            }
            if (searchClauses != null && searchClauses.size() > 0) {
                for (SearchClause sc : searchClauses) {
                    criteria.add(sc.getHibernateClause());
                }
            }
            if (orderByClauses != null && orderByClauses.size() > 0) {
                for (OrderByClause obc : orderByClauses) {
                    criteria.addOrder(obc.getHibernateClause());
                }
            }
            if (distinct) {
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            }
            log.debug((Object)("find by criteria: " + ToStringBuilder.reflectionToString((Object)criteria)));
            result = criteria.list();
            this.closeSession(session);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()), (Throwable)e);
            if (reportException) {
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<T> findByCriteria(List<SearchClause> searchClauses, List<OrderByClause> orderByClauses, List<CriteriaAlias> aliases, boolean distinct) {
        List<Object> result = new ArrayList();
        try {
            result = this.findByCriteria(searchClauses, orderByClauses, aliases, distinct, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findByCriteria(List<SearchClause> searchClauseList, List<OrderByClause> orderByClauseList, int skip, int maxLimit) {
        Session session = null;
        List result = new ArrayList();
        try {
            log.debug((Object)(">>> searchClauseList: " + searchClauseList));
            log.debug((Object)(">>> orderByClauseList: " + orderByClauseList));
            session = this.getSession();
            log.debug((Object)("Hibernate session: " + session));
            log.debug((Object)("Create criteria with class: " + this.persistentClass));
            Criteria criteria = session.createCriteria(this.persistentClass);
            criteria.setFirstResult(skip);
            criteria.setMaxResults(maxLimit);
            log.debug((Object)("Criteria instance: " + criteria));
            if (searchClauseList != null && searchClauseList.size() > 0) {
                log.debug((Object)"Adding search clauses");
                for (SearchClause sc : searchClauseList) {
                    criteria.add(sc.getHibernateClause());
                }
            }
            if (orderByClauseList != null && orderByClauseList.size() > 0) {
                log.debug((Object)"Adding order by clauses");
                for (OrderByClause obc : orderByClauseList) {
                    criteria.addOrder(obc.getHibernateClause());
                }
            }
            log.debug((Object)("find by criteria: " + ToStringBuilder.reflectionToString((Object)criteria)));
            result = criteria.list();
            this.closeSession(session);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findByCriteriaWithLimit(List<SearchClause> searchClauseList, List<OrderByClause> orderByClauseList, int maxLimit) {
        Session session = null;
        List result = new ArrayList();
        try {
            log.debug((Object)(">>> searchClauseList: " + searchClauseList));
            log.debug((Object)(">>> orderByClauseList: " + orderByClauseList));
            session = this.getSession();
            log.debug((Object)("Hibernate session: " + session));
            log.debug((Object)("Create criteria with class: " + this.persistentClass));
            Criteria criteria = session.createCriteria(this.persistentClass);
            criteria.setMaxResults(maxLimit);
            log.debug((Object)("Criteria instance: " + criteria));
            if (searchClauseList != null && searchClauseList.size() > 0) {
                log.debug((Object)"Adding search clauses");
                for (SearchClause sc : searchClauseList) {
                    criteria.add(sc.getHibernateClause());
                }
            }
            if (orderByClauseList != null && orderByClauseList.size() > 0) {
                log.debug((Object)"Adding order by clauses");
                for (OrderByClause obc : orderByClauseList) {
                    criteria.addOrder(obc.getHibernateClause());
                }
            }
            log.debug((Object)("find by criteria: " + ToStringBuilder.reflectionToString((Object)criteria)));
            result = criteria.list();
            this.closeSession(session);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findByNamedQuery(String queryName, List<QueryParam> queryParams) {
        Session session = null;
        List result = new ArrayList();
        try {
            log.debug((Object)(">>> query params: " + queryParams));
            session = this.getSession();
            log.debug((Object)("Hibernate session: " + session));
            Query query = session.getNamedQuery(queryName);
            log.debug((Object)("query: " + query));
            if (queryParams != null && queryParams.size() > 0) {
                log.debug((Object)"Adding query params");
                for (QueryParam qp : queryParams) {
                    query.setParameter(qp.getName(), qp.getValue());
                }
            }
            log.debug((Object)("find by named query: " + ToStringBuilder.reflectionToString((Object)query)));
            result = query.list();
            this.closeSession(session);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Exception caught: " + e.getMessage()), (Throwable)e);
                this.closeSession(session);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findByNamedQuery(String queryName, QueryParam ... queryParams) {
        Session session = null;
        List result = new ArrayList();
        try {
            session = this.getSession();
            Query query = session.getNamedQuery(queryName);
            if (queryParams != null) {
                for (int i = 0; i < queryParams.length; ++i) {
                    query.setParameter(queryParams[i].getName(), queryParams[i].getValue());
                }
            }
            log.debug((Object)("find by named query: " + ToStringBuilder.reflectionToString((Object)query)));
            result = query.list();
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findByIdRecursiveInit(ID id, List<String> methodPaths) {
        log.debug((Object)("find by id: " + id));
        Object obj = null;
        Session session = null;
        try {
            session = this.getSession();
            obj = session.get(this.persistentClass, id);
            if (obj == null) {
                log.info((Object)"skipping recursive init because return obj is null");
                Object object = obj;
                return (T)object;
            }
            Object m = null;
            ArrayList<String> methodNames = new ArrayList<String>();
            Object currentObj = obj;
            for (String methodPath : methodPaths) {
                log.debug((Object)("method path: " + methodPath));
                methodNames.addAll(Arrays.asList(methodPath.split("\\.")));
                log.debug((Object)("method name(s): " + methodNames));
                this.selectiveRecursiveInit(currentObj, methodNames);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e), (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return (T)obj;
    }

    private void selectiveRecursiveInit(Object obj, List<String> methodNames) throws Exception {
        try {
            Method m = null;
            Object currentObj = obj;
            String methodName = null;
            Iterator<String> iter = methodNames.iterator();
            log.debug((Object)("methodNames begin: " + methodNames));
            while (iter.hasNext()) {
                methodName = iter.next();
                log.info((Object)("methodName: " + methodName));
                if (currentObj instanceof Collection) {
                    log.debug((Object)("collection obj: " + currentObj.getClass().getName()));
                    log.debug((Object)("collection count: " + ((Collection)currentObj).size()));
                    int count = 0;
                    int methodCount = methodNames.size();
                    for (Object listItem : (Collection)currentObj) {
                        log.debug((Object)(count + " --- " + listItem.getClass().getName()));
                        if (methodCount == 1) {
                            log.info((Object)(methodNames.get(0) + " called on: " + listItem.getClass().getName()));
                            m = listItem.getClass().getMethod(methodNames.get(0), null);
                            currentObj = m.invoke(listItem, new Object[0]);
                            Hibernate.initialize((Object)currentObj);
                        } else {
                            log.debug((Object)(count + " --- call recursively"));
                            this.selectiveRecursiveInit(listItem, methodNames);
                        }
                        ++count;
                    }
                } else {
                    log.info((Object)(methodName + " called on: " + currentObj.getClass().getName()));
                    m = currentObj.getClass().getMethod(methodName, null);
                    currentObj = m.invoke(currentObj, new Object[0]);
                    Hibernate.initialize((Object)currentObj);
                }
                iter.remove();
                log.debug((Object)("updated methodNames: " + methodNames));
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
            throw e;
        }
    }

    public SessionFactory getSessionFactoryLocal() {
        return this.sessionFactoryLocal;
    }

    public void setSessionFactoryLocal(SessionFactory sessionFactoryLocal) {
        this.sessionFactoryLocal = sessionFactoryLocal;
    }
}

