/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.dao;

import gov.grants.commons.dao.SearchClause;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class EqualsClause
implements SearchClause {
    private static final transient Logger log = Logger.getLogger((String)EqualsClause.class.getName());
    private String propertyName;
    private Object value;
    private boolean trim = false;
    private boolean ignoreCase = false;

    public EqualsClause(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    public EqualsClause(String propertyName, String value, boolean trim, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.trim = trim;
        this.ignoreCase = ignoreCase;
        if (trim && StringUtils.isNotBlank((CharSequence)value)) {
            value = value.trim();
            value = value.toUpperCase();
        }
        this.value = value;
    }

    public EqualsClause(String propertyName, String value, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.ignoreCase = ignoreCase;
        this.value = value;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Criterion getHibernateClause() {
        log.debug((Object)("property name/value: " + this.propertyName + "/" + this.value));
        String sql = "{alias}." + this.propertyName;
        if (this.trim) {
            if (this.ignoreCase) {
                sql = "UPPER(" + sql + ")";
            }
            sql = "TRIM(" + sql + ")";
        }
        if (this.trim) {
            sql = sql + " = ?";
            log.info((Object)("sql: " + sql));
            return Restrictions.sqlRestriction((String)sql, (Object)this.value, (Type)StringType.INSTANCE);
        }
        if (this.ignoreCase) {
            return Restrictions.eq((String)this.propertyName, (Object)this.value).ignoreCase();
        }
        return Restrictions.eq((String)this.propertyName, (Object)this.value);
    }
}

