/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.daemon;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Heartbeat
implements Runnable {
    private static final Logger log = Logger.getLogger((String)Heartbeat.class.getName());
    private static final long DEFAULT_TIME_INTERVAL = 300000L;
    private long timeInterval = 300000L;
    private boolean threadActive = true;

    public Heartbeat() {
    }

    public Heartbeat(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public Heartbeat(String timeIntervalStr) {
        if (StringUtils.isBlank((String)timeIntervalStr)) {
            log.info((Object)"Time interval is blank --- using default time interval=300000 ms");
        } else if ("0".equals(timeIntervalStr)) {
            log.info((Object)"Time interval value = 0, turning heartbeat off");
            this.threadActive = false;
        } else {
            try {
                this.timeInterval = new Long(timeIntervalStr);
                log.info((Object)("Setting time interval=" + this.timeInterval + " ms"));
            }
            catch (Exception e) {
                log.error((Object)("Could not convert [" + timeIntervalStr + "] --- using default time interval=" + 300000L + " ms"));
                this.timeInterval = 300000L;
            }
        }
    }

    @Override
    public void run() {
        while (this.threadActive) {
            log.info((Object)("Application alive @ [" + new Date() + "]"));
            this.sleep();
        }
    }

    public void stop() {
        log.info((Object)"Setting active flag='false'");
        this.threadActive = false;
    }

    private void sleep() {
        try {
            log.debug((Object)("ZZZzzz ... for " + this.timeInterval + " ms"));
            Thread.sleep(this.timeInterval);
            log.debug((Object)("active=" + this.threadActive));
        }
        catch (Exception e) {
            log.error((Object)("EXCEPTION:\n" + e.getMessage()));
            e.printStackTrace();
            this.stop();
        }
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public boolean isThreadActive() {
        return this.threadActive;
    }

    public void setThreadActive(boolean threadActive) {
        this.threadActive = threadActive;
    }
}

