/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import gov.grants.commons.bizobj.ZipFileEntry;
import gov.grants.commons.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

public abstract class ZipPkg {
    private static final Logger log = Logger.getLogger((String)ZipPkg.class.getName());
    public static final String DEFAULT_MANIFEST_FILENAME = "manifest.txt";
    protected List<ZipFileEntry> zipEntries;
    protected String zipDir;
    protected String zipFilename;

    public abstract List<ZipFileEntry> getZipEntries();

    public abstract byte[] getManifestBytes() throws Exception;

    public String getZipFilePath() {
        return this.zipDir + File.separator + this.zipFilename;
    }

    public boolean addManifest(ZipArchiveOutputStream zos) {
        return this.addManifest(DEFAULT_MANIFEST_FILENAME, zos);
    }

    public boolean addManifest(String fileName, ZipArchiveOutputStream zos) {
        try {
            byte[] manifestBytes = this.getManifestBytes();
            return ZipUtil.addBytesToZip(new ZipArchiveEntry(fileName), manifestBytes, zos);
        }
        catch (IOException e) {
            log.error((Object)("IOException caught adding manifest to zip: " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Exception caught adding manifest to zip: " + e.getMessage()));
            return false;
        }
    }

    public String getZipDir() {
        return this.zipDir;
    }

    public void setZipDir(String zipDir) {
        this.zipDir = zipDir;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }
}

