/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.log4j.Logger;

public class ZipFileEntry {
    private static final Logger log = Logger.getLogger((String)ZipFileEntry.class.getName());
    private String zipEntryPath;
    private String filename;
    private String zipEntryFilename;
    private String fileDir;
    private int fileSize;
    private boolean calculateFileSize = false;
    private byte[] fileBytes;
    private boolean hasFileBytes = false;
    private String manifestFilename;

    public ZipFileEntry(String filename, String fileDir) {
        this.filename = filename;
        this.fileDir = fileDir;
    }

    public String toString() {
        ArrayList<String> excludeFieldNames = new ArrayList<String>();
        excludeFieldNames.add("fileBytes");
        return ReflectionToStringBuilder.toStringExclude((Object)this, excludeFieldNames);
    }

    public String getFilenameForManifest() {
        if (StringUtils.isNotBlank((String)this.manifestFilename)) {
            return this.manifestFilename;
        }
        return this.filename;
    }

    public ZipArchiveEntry getZipEntry() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.zipEntryPath)) {
            sb.append(this.zipEntryPath).append("/");
        }
        if (StringUtils.isNotBlank((String)this.zipEntryFilename)) {
            sb.append(this.zipEntryFilename);
        } else {
            sb.append(this.filename);
        }
        return new ZipArchiveEntry(sb.toString());
    }

    public String getFilePath() {
        String filepath = this.fileDir + File.separator + this.filename;
        log.debug((Object)("returning file path: " + filepath));
        return filepath;
    }

    public String getZipEntryPath() {
        return this.zipEntryPath;
    }

    public void setZipEntryPath(String zipEntryPath) {
        this.zipEntryPath = zipEntryPath;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public String getManifestFilename() {
        return this.manifestFilename;
    }

    public void setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
    }

    public boolean calculateFileSize() {
        return this.calculateFileSize;
    }

    public void setCalculateFileSize(boolean calculateFileSize) {
        this.calculateFileSize = calculateFileSize;
    }

    public byte[] getFileBytes() {
        return this.fileBytes;
    }

    public void setFileBytes(byte[] fileBytes) {
        if (fileBytes != null && fileBytes.length > 0) {
            this.hasFileBytes = true;
            this.fileSize = fileBytes.length;
            this.fileBytes = fileBytes;
        }
    }

    public boolean hasFileBytes() {
        return this.hasFileBytes;
    }

    public void setHasFileBytes(boolean hasFileBytes) {
        this.hasFileBytes = hasFileBytes;
    }

    public String getZipEntryFilename() {
        return this.zipEntryFilename;
    }

    public void setZipEntryFilename(String zipEntryFilename) {
        this.zipEntryFilename = zipEntryFilename;
    }
}

