/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import gov.grants.commons.bizobj.SystemConfiguration;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.Timer;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemConfigurationTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)SystemConfigurationTest.class.getName());
    private static final String FILE = "SystemConfiguration.xml";
    private static final String ELEMENT_NAME = "FormDAO";
    private Timer timer;

    @Before
    public void setUp() {
        try {
            this.timer = new Timer();
            this.timer.start();
            log.debug((Object)"Initialize SystemConfiguration class");
            InputStream inStream = BaseTest.class.getResourceAsStream(FILE);
            byte[] sysConfigXmlBytes = FileUtil.getBytes(inStream);
            log.debug((Object)("sysConfigXmlBytes size: " + sysConfigXmlBytes.length));
            SystemConfiguration.init(sysConfigXmlBytes);
            log.debug((Object)"Initialized SystemConfiguration class");
        }
        catch (Exception e) {
            log.error((Object)"Exception initializing SystemConfiguration.xml");
            Assert.fail((String)"Exception initializing SystemConfiguration.xml");
        }
    }

    @After
    public void tearDown() {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void test() {
        this.getValue();
    }

    public void getInt() {
        try {
            int value = SystemConfiguration.getInt(ELEMENT_NAME);
            log.debug((Object)("FormDAO = " + value));
        }
        catch (Exception ex) {
            log.error((Object)("Exception caught:\n" + ex.getMessage()));
        }
    }

    public void getValue() {
        try {
            String value = SystemConfiguration.getValue(ELEMENT_NAME);
            log.debug((Object)("FormDAO = " + value));
        }
        catch (Exception ex) {
            log.error((Object)("Exception caught:\n" + ex.getMessage()));
        }
    }
}

