/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDNav;
import gov.grants.commons.CommonsGlobals;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.VtdXmlUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SystemConfiguration {
    private static final String CLASSNAME = SystemConfiguration.class.getName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);
    private static String SYS_CONFIG_XML_FILENAME = null;
    private static String DEFAULT_SYS_CONFIG = CommonsGlobals.SYSTEM_CONFIG_DIR + File.separator + "SystemConfiguration.xml";
    private static boolean INITIALIZED = false;
    private static Map<String, String> CONFIG_MAP = new HashMap<String, String>();

    private SystemConfiguration() {
    }

    public static void init() {
        log.warn((Object)("Initializing with default system configuration:" + DEFAULT_SYS_CONFIG));
        try {
            SystemConfiguration.init(DEFAULT_SYS_CONFIG);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught initializing SystemConfiguration.xml:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void reloadConfig() {
        log.info((Object)("Reloading: " + SYS_CONFIG_XML_FILENAME));
        INITIALIZED = false;
        CONFIG_MAP.clear();
        SystemConfiguration.check();
    }

    public static synchronized void init(String sysConfigXmlFilename) throws Exception {
        try {
            if (CONFIG_MAP.isEmpty()) {
                log.info((Object)("Initializing " + CLASSNAME));
                if (StringUtils.isBlank((String)sysConfigXmlFilename)) {
                    throw new Exception("System configuration XML filename is blank");
                }
                SYS_CONFIG_XML_FILENAME = sysConfigXmlFilename;
                SystemConfiguration.init(FileUtil.readFile(sysConfigXmlFilename));
            } else {
                log.info((Object)"SystemConfigurationUtil already initialzied");
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught initializing SystemConfiguration.xml:" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    public static void init(byte[] systemConfigXmlBytes) throws Exception {
        try {
            if (CONFIG_MAP.isEmpty()) {
                log.info((Object)("Initializing " + CLASSNAME));
                if (systemConfigXmlBytes == null || systemConfigXmlBytes.length == 0) {
                    throw new Exception("System configuration XML bytes are blank");
                }
                log.info((Object)"parse config doc");
                VTDNav vn = VtdXmlUtil.createVTDNav(systemConfigXmlBytes, false);
                log.info((Object)"parsed config doc successfully");
                log.info((Object)("root: " + vn.toNormalizedString(vn.getCurrentIndex())));
                String xpath = null;
                xpath = "//*[text()='match-str']";
                xpath = "//*[text()]";
                AutoPilot ap = new AutoPilot();
                ap.bind(vn);
                ap.selectXPath(xpath);
                int index = -1;
                String elementName = null;
                String value = null;
                while ((index = ap.evalXPath()) != -1) {
                    elementName = vn.toNormalizedString(vn.getCurrentIndex());
                    value = vn.toRawString(vn.getText());
                    if (CONFIG_MAP.get(elementName) != null) {
                        log.warn((Object)("Duplicate value found: " + elementName + "=" + value));
                        continue;
                    }
                    CONFIG_MAP.put(elementName, value);
                }
                log.info((Object)("config map count: " + CONFIG_MAP.size()));
                if (!CONFIG_MAP.isEmpty()) {
                    log.info((Object)"SystemConfiguration util successfully initialized");
                    INITIALIZED = true;
                }
            } else {
                log.info((Object)"SystemConfiguration util already initialzied");
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught initializing SystemConfiguration.xml:" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    public static String getSystemConfigFilename() {
        return SYS_CONFIG_XML_FILENAME;
    }

    public static void addConfig(String key, String value) {
        SystemConfiguration.check();
        log.info((Object)("adding key-value for key: " + key));
        CONFIG_MAP.put(key, value);
    }

    public static void addConfig(String key, String value, boolean overwrite) {
        SystemConfiguration.check();
        if (!overwrite) {
            if (CONFIG_MAP.get(key) != null) {
                log.warn((Object)("Duplicate value found: " + key));
            } else {
                log.info((Object)("adding key-value for key: " + key));
                CONFIG_MAP.put(key, value);
            }
        } else {
            log.info((Object)("adding key-value for key: " + key));
            CONFIG_MAP.put(key, value);
        }
    }

    public static String getValue(String elementName) {
        String value;
        SystemConfiguration.check();
        if (StringUtils.isBlank((String)elementName)) {
            log.warn((Object)"element name is blank - returning null");
        }
        if (StringUtils.isBlank((String)(value = CONFIG_MAP.get(elementName)))) {
            log.info((Object)"Returning '' from SystemConfiguration.xml");
            return "";
        }
        log.debug((Object)(elementName + ": " + value));
        return value;
    }

    public static int getInt(String elementName) {
        SystemConfiguration.check();
        String value = SystemConfiguration.getValue(elementName);
        log.debug((Object)(elementName + " = " + value));
        int i = -1;
        try {
            if (StringUtils.isNotBlank((String)value)) {
                i = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Returning '-1' --- NFE caught converting [" + value + "]: " + e.getMessage()));
            return -1;
        }
        log.debug((Object)("Returning int: " + i));
        return i;
    }

    public static int getInt(String elementName, int defaultValue) {
        SystemConfiguration.check();
        String value = SystemConfiguration.getValue(elementName);
        log.debug((Object)(elementName + " = " + value));
        int i = defaultValue;
        try {
            if (StringUtils.isNotBlank((String)value)) {
                i = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("NFE caught converting [" + value + "]: " + e.getMessage()));
            return defaultValue;
        }
        log.debug((Object)("Returning int: " + i));
        return i;
    }

    public static String getString(String elementName) {
        return SystemConfiguration.getValue(elementName);
    }

    public static boolean getBoolean(String elementName) {
        String value = SystemConfiguration.getValue(elementName);
        log.debug((Object)(elementName + " = " + value));
        boolean b = false;
        if (StringUtils.isNotBlank((String)value)) {
            b = Boolean.parseBoolean(value);
        }
        log.debug((Object)("Returning boolean=" + b));
        return b;
    }

    public static String getDEFAULT_SYS_CONFIG() {
        return DEFAULT_SYS_CONFIG;
    }

    public static void setDEFAULT_SYS_CONFIG(String default_sys_config) {
        DEFAULT_SYS_CONFIG = default_sys_config;
    }

    private static void check() {
        if (!INITIALIZED) {
            log.warn((Object)("Initializing with default system configuration:" + DEFAULT_SYS_CONFIG));
            try {
                SYS_CONFIG_XML_FILENAME = DEFAULT_SYS_CONFIG;
                SystemConfiguration.init(DEFAULT_SYS_CONFIG);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getPendingRegistrationPeriod() {
        int pendingRegistrationExpirationPeriod = SystemConfiguration.getInt("PENDING_REGISTRATION_EXPIRATION");
        return pendingRegistrationExpirationPeriod < 48 ? 96 : pendingRegistrationExpirationPeriod;
    }
}

