/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import gov.grants.commons.bizobj.OpportunityKey;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.Timer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpportunityKeyTest
extends BaseTest {
    private static final Logger LOG = Logger.getLogger((String)OpportunityKeyTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() {
        LOG.debug((Object)"--- tearDown()");
        this.timer.stop();
        LOG.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void createValidOppKey() {
        try {
            String oppNum = null;
            String cfda = null;
            String compId = null;
            OpportunityKey oppKey = null;
            oppNum = "test-opp-num-123";
            cfda = "00.000";
            compId = "test-comp-id-123";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"valid", (Object)"oppTEST-OPP-NUM-123-cfda00.000-cidTEST-COMP-ID-123", (Object)oppKey.getFullName());
            oppNum = "test-opp-num-123";
            cfda = null;
            compId = "test-comp-id-123";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"cfda null", (Object)"oppTEST-OPP-NUM-123-cidTEST-COMP-ID-123", (Object)oppKey.getFullName());
            oppNum = "test-opp-num-123";
            cfda = "";
            compId = "test-comp-id-123";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"cfda empty", (Object)"oppTEST-OPP-NUM-123-cidTEST-COMP-ID-123", (Object)oppKey.getFullName());
            oppNum = "test-opp-num-123";
            cfda = "00.000";
            compId = null;
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"compId null", (Object)"oppTEST-OPP-NUM-123-cfda00.000", (Object)oppKey.getFullName());
            oppNum = "test-opp-num-123";
            cfda = "00.000";
            compId = "";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"compId empty", (Object)"oppTEST-OPP-NUM-123-cfda00.000", (Object)oppKey.getFullName());
            oppNum = "test-opp-num-123";
            cfda = "";
            compId = "";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)("oppKey: " + oppKey.getFullName()));
            Assert.assertEquals((String)"cfda/compId empty", (Object)"oppTEST-OPP-NUM-123", (Object)oppKey.getFullName());
        }
        catch (Exception e) {
            LOG.error((Object)("exception type: " + e.getClass().getName()));
            LOG.error((Object)("Exception caught:\n" + e.getMessage()));
        }
    }

    @Test
    public void oppNumNull() {
        try {
            String oppNum = null;
            String cfda = null;
            String compId = null;
            OpportunityKey oppKey = null;
            oppNum = null;
            cfda = "00.000";
            compId = "test-comp-id-123";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)"opportunity number null --- success");
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("IllegalArgumentException caught:\n" + e.getMessage()));
        }
    }

    @Test
    public void oppNumEmpty() {
        try {
            String oppNum = null;
            String cfda = null;
            String compId = null;
            OpportunityKey oppKey = null;
            oppNum = "";
            cfda = "00.000";
            compId = "test-comp-id-123";
            oppKey = new OpportunityKey(oppNum, cfda, compId);
            LOG.debug((Object)"opportunity number empty --- success");
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("IllegalArgumentException caught:\n" + e.getMessage()));
        }
    }
}

