/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class OpportunityKey {
    public static final String OPPORTUNITY_NUMBER_PREFIX = "opp";
    public static final String CFDA_NUMBER_PREFIX = "-cfda";
    public static final String COMPETITION_ID_PREFIX = "-cid";
    private String opportunityNumber;
    private String cfdaNumber;
    private String competitionId;

    public OpportunityKey(String opportunityNumber, String cfdaNumber, String competitionId) throws IllegalArgumentException {
        Validate.notEmpty((String)opportunityNumber, (String)"Opportunity Number cannot be blank");
        this.setOpportunityNumber(opportunityNumber);
        this.setCFDANumber(cfdaNumber);
        this.setCompetitionId(competitionId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getFullName() {
        StringBuilder name = new StringBuilder(OPPORTUNITY_NUMBER_PREFIX);
        name.append(this.opportunityNumber);
        if (StringUtils.isNotBlank((String)this.cfdaNumber)) {
            name.append(CFDA_NUMBER_PREFIX).append(this.cfdaNumber);
        }
        if (StringUtils.isNotBlank((String)this.competitionId)) {
            name.append(COMPETITION_ID_PREFIX).append(this.competitionId);
        }
        return name.toString();
    }

    public String getOpportunityNumber() {
        return this.opportunityNumber;
    }

    public void setOpportunityNumber(String opportunityNumber) {
        if (StringUtils.isNotBlank((String)opportunityNumber)) {
            this.opportunityNumber = opportunityNumber.toUpperCase();
        }
    }

    public String getCFDANumber() {
        return this.cfdaNumber;
    }

    public void setCFDANumber(String cfdaNumber) {
        if (StringUtils.isNotBlank((String)cfdaNumber)) {
            this.cfdaNumber = cfdaNumber.toUpperCase();
        }
    }

    public String getCompetitionId() {
        return this.competitionId;
    }

    public void setCompetitionId(String competitionId) {
        if (StringUtils.isNotBlank((String)competitionId)) {
            this.competitionId = competitionId.toUpperCase();
        }
    }
}

