/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import com.google.gson.Gson;
import gov.grants.commons.bizobj.Activity;
import gov.grants.commons.type.GGUserType;
import gov.grants.commons.type.PrivilegeType;
import gov.grants.commons.vo.GGSSOUserProfile;
import gov.grants.commons.vo.SwitchProfileMenu;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class GGSSOUser
implements Serializable {
    private static final transient Logger log = Logger.getLogger((String)GGSSOUser.class.getName());
    private static final long serialVersionUID = 1L;
    private String uid;
    private GGSSOUserProfile currentGrantorProfile;
    private List<GGSSOUserProfile> applicantProfiles = new ArrayList<GGSSOUserProfile>();
    private List<GGSSOUserProfile> grantorProfiles = new ArrayList<GGSSOUserProfile>();
    private List<Activity> connectActivities = new ArrayList<Activity>();
    private boolean isDuplicateEmail = false;
    private String currentAgency;
    private String origAgency;
    private boolean isNoProfile = false;
    private String firstName;
    private String middleName;
    private String lastName;
    private String email;
    private String sessionJSONStr;
    private long spoeeId = 0L;
    private Set<PrivilegeType> applicantPrivilegeTypes = new HashSet<PrivilegeType>();

    public GGSSOUser() {
    }

    public GGSSOUser(String uid, String firstName, String middleName, String lastName, String email, GGSSOUserProfile currentGrantorProfile, List<GGSSOUserProfile> otherProfiles) {
        this.uid = uid;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.email = email;
        this.currentGrantorProfile = currentGrantorProfile;
        for (GGSSOUserProfile profile : otherProfiles) {
            if (profile.isApplicantProfile()) {
                this.applicantProfiles.add(profile);
                continue;
            }
            this.grantorProfiles.add(profile);
        }
        this.initApplicantPrivilegeTypes();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isAgency() {
        return this.isGrantor();
    }

    public boolean isGrantor() {
        return this.currentGrantorProfile != null;
    }

    public boolean canManageWorkspace() {
        if (this.currentGrantorProfile != null) {
            return false;
        }
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!profile.canManageWorkspace()) continue;
            return true;
        }
        return false;
    }

    public boolean isApplicantUserType() {
        return this.currentGrantorProfile == null && !this.isNoProfile;
    }

    public boolean isIndvApplicant() {
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!profile.isIndvApplicant()) continue;
            return true;
        }
        return false;
    }

    public boolean isOrgApplicant() {
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!profile.isOrgApplicant()) continue;
            return true;
        }
        return false;
    }

    public boolean isEBiz() {
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!profile.isEBiz()) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkspacePartner() {
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (profile.getType() == null || !profile.getType().equals((Object)GGUserType.WORKSPACE_PARTNER)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuthorized() {
        return this.hasAnyPrivilege(PrivilegeType.SUBMIT_APPLICATIONS_ORG, PrivilegeType.SUBMIT_APPLICATIONS_OWN, PrivilegeType.CHECK_APPLICATION_STATUS_ORG);
    }

    public String getUidWithoutPrefix() {
        return this.getUid();
    }

    public long getProfileId() {
        return this.currentGrantorProfile != null ? this.currentGrantorProfile.getId() : 0L;
    }

    public int getUserType() {
        if (this.currentGrantorProfile != null) {
            return GGUserType.AGENCY.id();
        }
        if (this.isEBiz()) {
            return GGUserType.EBIZ.id();
        }
        return GGUserType.APPLICANT.id();
    }

    public boolean hasOtherVisibleProfiles() {
        if (this.applicantProfiles.isEmpty() && this.grantorProfiles.isEmpty()) {
            return false;
        }
        if (this.grantorProfiles.size() > 1) {
            return true;
        }
        return this.applicantProfiles.size() > 0 && this.grantorProfiles.size() > 0;
    }

    public List<GGSSOUserProfile> getAllProfiles() {
        ArrayList<GGSSOUserProfile> allProfiles = new ArrayList<GGSSOUserProfile>();
        allProfiles.addAll(this.grantorProfiles);
        allProfiles.addAll(this.applicantProfiles);
        return allProfiles;
    }

    public GGSSOUserProfile getApplicantProfile(String duns) {
        if (this.applicantProfiles.isEmpty()) {
            return null;
        }
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!duns.equalsIgnoreCase(profile.getDuns()) && !duns.equalsIgnoreCase(profile.getSamUei())) continue;
            return profile;
        }
        return null;
    }

    public void updateCurrentGrantorProfile(long profileId) {
        if (!this.hasOtherVisibleProfiles()) {
            return;
        }
        if (profileId == 0L) {
            log.info((Object)"switching to applicant profiles");
            this.currentGrantorProfile = null;
            return;
        }
        log.info((Object)"switching to grantor profile");
        for (GGSSOUserProfile profile : this.grantorProfiles) {
            if (profileId != profile.getId()) continue;
            this.currentGrantorProfile = profile;
            log.info((Object)("updated current grantor profile: " + this.currentGrantorProfile.getName()));
            return;
        }
        log.warn((Object)("profile not found for id: " + profileId));
    }

    public String getSwitchProfileMenuJson() {
        String defaultJson = "{}";
        try {
            if (!this.hasOtherVisibleProfiles()) {
                log.info((Object)(this.getUid() + " does not have other visible profiles"));
                return defaultJson;
            }
            log.info((Object)"create switch profile menu");
            SwitchProfileMenu menu = new SwitchProfileMenu();
            if (this.currentGrantorProfile != null) {
                menu.setCurrentProfile(this.currentGrantorProfile);
            } else {
                log.debug((Object)("all applicant duns: " + this.getAllDuns()));
                if (!this.applicantProfiles.isEmpty()) {
                    log.debug((Object)"add applicant profile as current profile");
                    menu.setCurrentProfile(this.createApplicantMenuProfile());
                }
            }
            for (GGSSOUserProfile profile : this.grantorProfiles) {
                if (profile.isDeleted() || !profile.isVisible()) continue;
                if (this.currentGrantorProfile == null) {
                    menu.addOtherProfile(profile);
                    continue;
                }
                if (this.currentGrantorProfile.getId() == profile.getId()) continue;
                menu.addOtherProfile(profile);
            }
            menu.sortOtherProfiles();
            if (this.currentGrantorProfile != null && !this.applicantProfiles.isEmpty()) {
                log.debug((Object)"add applicant profile to end of list");
                menu.addOtherProfile(this.createApplicantMenuProfile());
            }
            String jsonData = new Gson().toJson((Object)menu);
            return jsonData;
        }
        catch (Exception e) {
            log.error((Object)e);
            return defaultJson;
        }
    }

    public String getApplicantProfilesJson() {
        String defaultJson = "{}";
        try {
            log.debug((Object)"serialize ssouser obj");
            defaultJson = new Gson().toJson((Object)this);
            log.debug((Object)"de-serialize - create new obj");
            GGSSOUser user = (GGSSOUser)new Gson().fromJson(defaultJson, GGSSOUser.class);
            log.debug((Object)"clear unnecessary properties");
            user.setGrantorProfiles(null);
            user.setCurrentAgency(null);
            user.setCurrentAgency(null);
            user.setOrigAgency(null);
            user.prepareApplicantProfiles();
            log.debug((Object)"serialize updated ggssouser");
            String jsonData = new Gson().toJson((Object)user);
            return jsonData;
        }
        catch (Exception e) {
            log.error((Object)e);
            return defaultJson;
        }
    }

    public GGSSOUser prepareApplicantProfilesUser() {
        String defaultJson = "{}";
        try {
            log.debug((Object)"serialize ssouser obj");
            defaultJson = new Gson().toJson((Object)this);
            log.debug((Object)"de-serialize - create new obj");
            GGSSOUser user = (GGSSOUser)new Gson().fromJson(defaultJson, GGSSOUser.class);
            log.debug((Object)"clear unnecessary properties");
            user.setGrantorProfiles(null);
            user.setCurrentAgency(null);
            user.setCurrentAgency(null);
            user.setOrigAgency(null);
            user.prepareApplicantProfiles();
            return user;
        }
        catch (Exception e) {
            log.error((Object)e);
            return this;
        }
    }

    private void prepareApplicantProfiles() {
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            profile.setActivities(null);
            profile.initJsonValues();
        }
    }

    public Collection<String> getRoles() {
        if (this.currentGrantorProfile != null) {
            return this.currentGrantorProfile.getRoles();
        }
        HashSet<String> roles = new HashSet<String>();
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            roles.addAll(profile.getRoles());
        }
        return roles;
    }

    public Collection<String> getAllDuns() {
        HashSet<String> duns = new HashSet<String>();
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            duns.add(profile.getDuns());
        }
        return duns;
    }

    public List<Activity> getActivities() {
        if (this.currentGrantorProfile != null) {
            return this.currentGrantorProfile.getActivities();
        }
        HashMap<String, Activity> m = new HashMap<String, Activity>();
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            m.putAll(profile.getActivityMap());
        }
        ArrayList<Activity> l = new ArrayList<Activity>();
        l.addAll(m.values());
        Collections.sort(l, new Activity.SortByOrderNumber());
        return l;
    }

    public Set<String> getMpinValidatedDuns() {
        HashSet<String> duns = new HashSet<String>();
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!profile.isMpinValidated()) continue;
            duns.add(profile.getDuns());
        }
        return duns;
    }

    public boolean hasPrivilege(PrivilegeType privilegeType) {
        if (this.isGrantor()) {
            return this.currentGrantorProfile.hasPrivilege(privilegeType);
        }
        if (this.isApplicantUserType()) {
            return this.applicantPrivilegeTypes.contains((Object)privilegeType);
        }
        return false;
    }

    public boolean hasPrivilege(String duns, PrivilegeType privilegeType) {
        if (this.isApplicantUserType()) {
            return this.hasPrivileges(duns, true, privilegeType);
        }
        return false;
    }

    public boolean hasAnyPrivilege(PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(false, privilegeTypes);
    }

    public boolean hasAnyPrivilege(String duns, PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(duns, false, privilegeTypes);
    }

    public boolean hasAllPrivileges(PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(true, privilegeTypes);
    }

    public boolean hasAllPrivileges(String duns, PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(duns, true, privilegeTypes);
    }

    public boolean hasPrivileges(boolean hasAllPrivileges, PrivilegeType ... privilegeTypes) {
        if (this.isGrantor()) {
            return this.currentGrantorProfile.hasPrivileges(hasAllPrivileges, privilegeTypes);
        }
        if (this.isApplicantUserType()) {
            if (hasAllPrivileges) {
                return this.applicantPrivilegeTypes.containsAll(Arrays.asList(privilegeTypes));
            }
            for (PrivilegeType type : privilegeTypes) {
                if (!this.applicantPrivilegeTypes.contains((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPrivileges(String duns, boolean hasAllPrivileges, PrivilegeType ... privilegeTypes) {
        if (this.applicantProfiles.isEmpty()) {
            return false;
        }
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (!duns.equals(profile.getDuns())) continue;
            return profile.hasPrivileges(hasAllPrivileges, privilegeTypes);
        }
        return false;
    }

    public Set<String> getDunsWithoutPrivilege(PrivilegeType type) {
        HashSet<String> duns = new HashSet<String>();
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            if (profile.hasPrivilege(type)) continue;
            duns.add(profile.getDuns());
        }
        return duns;
    }

    private GGSSOUserProfile createApplicantMenuProfile() {
        GGSSOUserProfile p = new GGSSOUserProfile();
        p.setName("My Applicant Profile(s)");
        return p;
    }

    private void initApplicantPrivilegeTypes() {
        if (this.applicantProfiles.isEmpty()) {
            return;
        }
        Set<PrivilegeType> types = null;
        for (GGSSOUserProfile profile : this.applicantProfiles) {
            types = profile.getPrivilegeTypes();
            if (types.isEmpty()) continue;
            this.applicantPrivilegeTypes.addAll(types);
        }
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCurrentAgency() {
        return this.currentAgency;
    }

    public void setCurrentAgency(String currentAgency) {
        this.currentAgency = currentAgency;
    }

    public String getOrigAgency() {
        return this.origAgency;
    }

    public void setOrigAgency(String origAgency) {
        this.origAgency = origAgency;
    }

    public GGSSOUserProfile getCurrentGrantorProfile() {
        return this.currentGrantorProfile;
    }

    public void setCurrentGrantorProfile(GGSSOUserProfile currentGrantorProfile) {
        this.currentGrantorProfile = currentGrantorProfile;
    }

    public List<GGSSOUserProfile> getApplicantProfiles() {
        return this.applicantProfiles;
    }

    public void setApplicantProfiles(List<GGSSOUserProfile> applicantProfiles) {
        this.applicantProfiles = applicantProfiles;
    }

    public List<GGSSOUserProfile> getGrantorProfiles() {
        return this.grantorProfiles;
    }

    public void setGrantorProfiles(List<GGSSOUserProfile> grantorProfiles) {
        this.grantorProfiles = grantorProfiles;
    }

    public long getSpoeeId() {
        return this.spoeeId;
    }

    public void setSpoeeId(long spoeeId) {
        this.spoeeId = spoeeId;
    }

    public boolean hasNoProfile() {
        return this.isNoProfile;
    }

    public List<Activity> getConnectActivities() {
        return this.connectActivities;
    }

    public void setConnectActivities(List<Activity> connectActivities) {
        this.connectActivities = connectActivities;
    }

    public boolean isNoProfile() {
        return this.isNoProfile;
    }

    public void setNoProfile(boolean isNoProfile) {
        this.isNoProfile = isNoProfile;
    }

    public boolean isDuplicateEmail() {
        return this.isDuplicateEmail;
    }

    public void setIsDuplicateEmail(boolean isDuplicateEmail) {
        this.isDuplicateEmail = isDuplicateEmail;
    }

    public String getSessionJSONStr() {
        return this.sessionJSONStr;
    }

    public void setSessionJSONStr(String sessionJSONStr) {
        this.sessionJSONStr = sessionJSONStr;
    }
}

