/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.bizobj;

import gov.grants.commons.bizobj.SystemConfiguration;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class GGCertificate {
    private static final Logger log = Logger.getLogger((String)GGCertificate.class.getName());
    private X509Certificate cert = null;
    private Hashtable<String, String> info = new Hashtable();
    private String serialNum = null;

    public GGCertificate(X509Certificate cert) {
        this.cert = cert;
        if (cert != null) {
            this.initCertInfo();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void initCertInfo() {
        String nxtToken = "";
        String subjectID = "";
        String subjectValue = "";
        int equalsFound = 0;
        log.debug((Object)"Get cert info");
        Principal prin = this.cert.getSubjectDN();
        StringTokenizer st = new StringTokenizer(prin.toString(), ",");
        while (st.hasMoreTokens()) {
            nxtToken = st.nextToken();
            if (nxtToken.endsWith(",")) {
                nxtToken = nxtToken.substring(0, nxtToken.length() - 1);
            }
            if ((equalsFound = nxtToken.indexOf("=")) <= 0) continue;
            subjectID = nxtToken.substring(0, equalsFound);
            subjectID = subjectID.trim();
            subjectValue = nxtToken.substring(equalsFound + 1, nxtToken.length());
            subjectValue = subjectValue.trim();
            this.info.put(subjectID, subjectValue);
        }
        this.serialNum = this.cert.getSerialNumber().toString();
        log.debug((Object)("Cert serial number=" + this.serialNum));
        this.info.put(SystemConfiguration.getString("DCUID"), this.serialNum);
        log.debug((Object)("Cert info=" + this.info));
    }

    public Hashtable<String, String> getCertInfo() {
        return this.info;
    }

    public String getSerialNum() {
        return this.serialNum;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }
}

