/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons;

import gov.grants.commons.CommonsGlobals;
import gov.grants.commons.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XMLConstants {
    private static final Logger log = Logger.getLogger((String)XMLConstants.class.getName());
    private static final String NAMESPACE_MAP_ELEMENT_NAME = "NamespaceMap";
    private static final String NAMESPACE_REGEX_MAP_ELEMENT_NAME = "NamespaceRegexMap";
    private static final Map<String, String> COMMON_XMLNS_MAP = new HashMap<String, String>();
    private static final Map<String, String> XMLNS_MAP = new HashMap<String, String>();
    private static final Map<String, String> XMLNS_REGEX_MAP = new HashMap<String, String>();

    private XMLConstants() {
    }

    public static Map<String, String> getCommonXmlNsMap() {
        if (COMMON_XMLNS_MAP.size() == 0) {
            XMLConstants.initCommonXmlNsMap();
        }
        return COMMON_XMLNS_MAP;
    }

    public static Map<String, String> getXmlNsMap() {
        if (XMLNS_MAP.size() == 0) {
            XMLConstants.initXmlConstantsProperties();
        }
        return XMLNS_MAP;
    }

    public static Map<String, String> getXmlNsRegexMap() {
        if (XMLNS_REGEX_MAP.size() == 0) {
            XMLConstants.initXmlConstantsProperties();
        }
        return XMLNS_REGEX_MAP;
    }

    private static void initXmlConstantsProperties() {
        String propsFile = CommonsGlobals.SYSTEM_CONFIG_DIR + File.separator + "XMLConstantsProperties.xml";
        try {
            byte[] xmlBytes = FileUtil.readFile(propsFile);
            SAXReader reader = new SAXReader();
            log.debug((Object)"Create InputStream");
            ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlBytes);
            log.debug((Object)"Read InputStream");
            Document xmlDoc = reader.read((InputStream)xmlInputStream);
            log.debug((Object)"Populate maps");
            Element root = xmlDoc.getRootElement();
            List entries = root.element(NAMESPACE_MAP_ELEMENT_NAME).elements("entry");
            log.debug((Object)("NamespaceMap entries=" + entries));
            for (Element entry : entries) {
                log.debug((Object)("entry=" + entry));
                XMLNS_MAP.put(entry.elementText("key"), entry.elementText("value"));
            }
            log.debug((Object)("XMLNS_MAP=" + XMLNS_MAP));
            entries = root.element(NAMESPACE_REGEX_MAP_ELEMENT_NAME).elements("entry");
            log.debug((Object)("NamespaceRegexMap entries=" + entries));
            for (Element entry : entries) {
                XMLNS_REGEX_MAP.put(entry.elementText("key"), entry.elementText("value"));
            }
            log.debug((Object)("XMLNS_REGEX_MAP=" + XMLNS_REGEX_MAP));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught loading [" + propsFile + "]:\n" + e.getMessage()));
            System.exit(0);
        }
    }

    private static void initCommonXmlNsMap() {
        COMMON_XMLNS_MAP.put("att", "http://apply.grants.gov/system/Attachments-V1.0");
        COMMON_XMLNS_MAP.put("glob", "http://apply.grants.gov/system/Global-V1.0");
        COMMON_XMLNS_MAP.put("grant", "http://apply.grants.gov/system/MetaGrantApplication");
        COMMON_XMLNS_MAP.put("header", "http://apply.grants.gov/system/Header-V1.0");
    }
}

