/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons;

public class AuditLookupConstants {

    public static enum AuditSource {
        ONLINE(1, false, true),
        EMAIL(2, false, true),
        WEB_SERVICE(3, false, true),
        SAM(4, false, true),
        PDF_SUBMISSION(5, false, true),
        WRSP_SUBMISSION(6, false, true),
        WRSP_DELETE(7, false, true),
        NIGHTLY_DEACTIVATE(8, false, true),
        UI_DEACTIVATE(9, false, true),
        REGISTER(10, false, true),
        LOGIN(11, false, true),
        CHNG_PASSWORD_PUBLIC(12, false, true),
        CHNG_PASSWORD_LOG_IN(13, false, true),
        PASSWORD_RESET(14, false, true),
        USER_PROVIDED(15, false, true),
        SYSTEM_GEN(16, false, true),
        MANAGE_PROFILE(17, false, true),
        LOGIN_LEGACY(18, false, true),
        MPIN_ENTRY(19, false, true),
        THIRD_PARTY_S2S(20, false, true),
        UI_MANAGE_ROLES(21, false, true),
        UI_ACCESS_REVOKED(22, false, true),
        MANAGE_ORG_PROFILE(23, false, true),
        GRANTOR_UI(24, true, true),
        GRANTOR_S2S(25, true, false),
        SUPPORT(26, true, true),
        MAINTENANCE_SCRIPTS(27, false, false),
        APPL_S2S(28, false, true),
        UI_MANAGE_ORGANIZATION_ROLE(30),
        FEDERATED_LINK(31, false, true),
        FEDERATED_LINK_PIV(3101, false, true),
        FEDERATED_LINK_AMS(3102, false, true),
        FEDERATED_LINK_LOGIN_GOV(3103, false, true),
        MOBILE_LOGIN(32, false, true);

        private boolean agencyIndicator;
        private boolean userActivityIndicator;
        private int id;

        private AuditSource(int id) {
            this.id = id;
        }

        private AuditSource(int id, boolean agencyIndicator, boolean userActivityIndicator) {
            this.id = id;
            this.agencyIndicator = agencyIndicator;
            this.userActivityIndicator = userActivityIndicator;
        }

        public static boolean isAgency(int id) {
            for (AuditSource source : AuditSource.values()) {
                if (id != source.id) continue;
                return source.agencyIndicator;
            }
            return false;
        }

        public static boolean isUserActivity(int id) {
            for (AuditSource source : AuditSource.values()) {
                if (id != source.id) continue;
                return source.userActivityIndicator;
            }
            return true;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum AuditAction {
        ADDED(1, true, true),
        MODIFIED(2, true, true),
        DEACTIVATED(3, false, true),
        REGISTERED(4, false, true),
        ROLE_ASSIGNED(5, false, true),
        ROLE_REVOKED(6, false, true),
        REACTIVATED(7, false, true),
        AUTHENTICATED(8, false, true),
        AUTHENTICATE_FAILED(9, false, true),
        PASSWORD_CHANGED(10, false, true),
        PASSWORD_RESET(11, false, true),
        ACCOUNT_LOCKED(12, false, true),
        MPIN_AUTHORIZED(13, false, true),
        SAM_DEACTIVATED(14, false, true),
        SAM_REACTIVATED(15, false, true),
        MPIN_AUTHORIZE_FAILED(16, false, true),
        SECRET_ANSWER_AUTHORIZED(17, false, true),
        SECRET_ANSWER_AUTHORIZE_FAILED(18, false, true),
        ACCESS_ASSIGNED(19, false, true),
        ACCESS_REVOKED(20, false, true),
        DELETED(21, true, true),
        SUBMITTED(22, false, true),
        MERGED(23, false, true),
        FIXED_USERNAME(24, false, true),
        ROLE_ADDED(25, "Added"),
        ROLE_DELETED(26, "Deleted"),
        ROLE_MODIFIED(27, "Modified"),
        ROLE_ACTIVATED(28, "Activated"),
        ROLE_INACTIVATED(29, "Inactivated"),
        ACCOUNT_LINKED(30, false, true);

        private boolean agencyIndicator;
        private boolean userActivityIndicator;
        private int id;
        private String desc;

        private AuditAction(int id) {
            this.id = id;
        }

        private AuditAction(int id, boolean agencyIndicator, boolean userActivityIndicator) {
            this.id = id;
            this.agencyIndicator = agencyIndicator;
            this.userActivityIndicator = userActivityIndicator;
        }

        private AuditAction(int id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public static boolean isAgency(int id) {
            for (AuditAction action : AuditAction.values()) {
                if (id != action.id) continue;
                return action.agencyIndicator;
            }
            return false;
        }

        public static boolean isUserActivity(int id) {
            for (AuditAction action : AuditAction.values()) {
                if (id != action.id) continue;
                return action.userActivityIndicator;
            }
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String getDesc() {
            return this.desc;
        }

        public static AuditAction fromId(int id) {
            for (AuditAction auditAction : AuditAction.values()) {
                if (auditAction.getId() != id) continue;
                return auditAction;
            }
            return null;
        }
    }

    public static enum AuditActionCategory {
        PROFILE(1),
        ROLE(2),
        ACCOUNT(3),
        ORGANIZATION(4),
        TEMPLATE(5),
        PACKAGE(6),
        SYNOPSIS(7),
        OPPORTUNITY(8),
        AGENCY(9),
        RELATED_DOCUMENTS(10),
        FORECAST(11),
        APPLICATION(12),
        ORGANIZATION_ROLE(13),
        FON_RELATIONSHIP(14);

        private int id;

        private AuditActionCategory(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum AuditUserType {
        USER(9),
        APPLICANT(2),
        GRANTOR(3),
        EBIZ_POC(4),
        ORGANIZATION(5),
        CERTIFICATE_GRANTOR(6),
        CERTIFICATE_APPLICANT(7),
        SYSTEM(8);

        private int id;

        private AuditUserType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

